﻿using System;
using System.Collections.Generic;
using System.Text;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    /// <summary>
    /// Bazowy obiekt API
    /// </summary>
    public class GExerciseMeta
    {
        public int pages_count { get; set; }
        public int pages_current { get; set; }
        public bool is_next_page { get; set; }
        public bool is_prev_page { get; set; }
        public bool can_solve { get; set; }
        public bool can_check_correct { get; set; }
        public bool is_menu { get; set; }

        public GExerciseMeta() {}

        public GExerciseMeta(BL.ZSBELearning.ContextParam ContextParam) 
        {
            if (ContextParam.AuxyliaryPages == BL.Dictionary.AuxyliaryPagesType.None)
            {
                pages_count = ContextParam.PageCount;
                pages_current = ContextParam.PageNr;
            }
            else
            {
                pages_count = 0;
                pages_current = 0;
            }

            is_next_page = ContextParam.BreadcrumbsMenu.IsNextExercise;
            is_prev_page = ContextParam.BreadcrumbsMenu.IsPreviousExercise;
            can_solve = ContextParam.BreadcrumbsMenu.IsResolve;
            can_check_correct = ContextParam.BreadcrumbsMenu.IsCheck;
            is_menu = ContextParam.BreadcrumbsMenu.IsMenu;
        }
    }
}
